

<?php $__env->startSection('title'); ?>
    <div class="w-full py-5">
        <div class="w-full flex justify-center">
            <div class="w-11/12 rounded-md bg-[#0e1726] p-2 md:p-4">
                <div class="flex justify-between items-center">
                    <div>
                        
                        <h2 class="bg-transparent text-[#ebedf2] font-medium capitalize">
                            Send Email
                        </h2>
                    </div>
                    <div>
                        <a href="<?php echo e(url()->previous()); ?>"
                            class="flex justify-start items-center text-xs text-gray-400 hover:text-white">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="none" viewBox="0 0 24 24"
                                stroke="currentColor" stroke-width="2">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M11 17l-5-5m0 0l5-5m-5 5h12" />
                            </svg>
                            <span>back</span>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="w-full py-5">
        <div class="w-full flex justify-center">
            <div class="w-11/12 rounded-md bg-[#0e1726] text-[#bfc9d4] p-3 md:p-5">
                <div class="">
                    <div>
                        <h3 class="font-medium capitalize">Enter email data</h3>
                        <h6 class="text-blue-400 text-xs">
                            most hosting providers limit the number of emails that can be bulk sent per hour. Check with your hosting provider
                        </h6>
                    </div>
                </div>
                <hr class="w-full border-b border-dotted border-gray-600 border my-2">

                <form class="px-3 md:px-5 mt-8" action="<?php echo e(route('admin.users.email-validate')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="h-44 overflow-y-scroll overflow-x-hidden mb-3">
                        <?php if(request()->has('email')): ?>
                            <input type="hidden" name="email" id="email" value="<?php echo e(urldecode(request()->email)); ?>">
                        <?php elseif(session()->has('emails')): ?>
                            <table class="mb-3">
                                <?php $__currentLoopData = session()->get('emails'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $email): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><label for="<?php echo e($email); ?>"><?php echo e($email); ?></label></td>
                                        <td class="px-2"></td>
                                        <td><input type="checkbox" name="emails[]" checked value="<?php echo e($email); ?>"
                                                id="<?php echo e($email); ?>"></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </table>
                        <?php else: ?>
                            <table class="mb-3">
                                <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><label for="<?php echo e($user->email); ?>"><?php echo e($user->email); ?></label></td>
                                        <td class="px-2"></td>
                                        <td><input type="checkbox" name="emails[]" checked value="<?php echo e($user->email); ?>"
                                                id="<?php echo e($user->email); ?>"></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </table>
                        <?php endif; ?>

                    </div>



                    <?php if(request()->has('return_url')): ?>
                        <input type="hidden" name="return_url" id="return_url"
                            value="<?php echo e(urldecode(request()->return_url)); ?>">
                    <?php endif; ?>

                    <div class="grid grid-cols-1">
                        <div class="relative">
                            <span class="cred-hyip-theme1-input-icon material-icons">
                                mail
                            </span>
                            <input class="cred-hyip-theme1-text-input" type="text" name="subject" id="subject"
                                placeholder="Email subject" required>
                            <span>
                                <?php $__errorArgs = ['subject'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <?php echo e($message); ?>

                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </span>
                        </div>
                    </div>

                    <div class="grid grid-cols-1 mt-5">
                        <textarea class="cred-hyip-theme1-textarea pl-3" name="message" id="message" placeholder="Email message"
                            rows="10" required><?php echo e(old('message')); ?></textarea>
                        <span>
                            <?php $__errorArgs = ['message'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <?php echo e($message); ?>

                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </span>
                    </div>

                    <div class="w-full my-5 px-5">
                        <button type="submit"
                            class="w-full text-xs md:text-sm text-[#d1d5db] text-center px-5 py-3 my-5 bg-[#1b2e4b] hover:bg-gray-700 rounded-md">
                            Send email
                        </button>
                    </div>
                </form>


            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\USER\Desktop\moved_files\project\credhyip\core\resources\views/admin/users/email.blade.php ENDPATH**/ ?>